s         p     ˜                                              tg1304      Thurlby Thandar TG1304 Func. Generator        	     Instrument Name: Thurlby Thandar TG1304 13MHz
                  Function Generator.

 Description:     This instrument module provides
                  programming support for the
                  TG1304.  The module is divided
                  into the following functions:

 Functions/Classes:

 (1) Initialize
     Initialize the instrument and optionally
     interrogate the ID and set to the specified
     reset conditions.

 (2) Configure...
     This class of functions configures the main
     and Auxilliary generators and allows access
     to the Modulation capabilities of the TG1304.
        (1) Main Generator
            Set up such TG1304 Main Generator
            parameters as  output function,
            frequency and amplitude.
        (2) Auxiliary Generator
            Set up such TG1304 Auxiliary Generator
            parameters as  output function,
            frequency and amplitude.
        (3) Modulation...
            This class of functions configures and
            controls the Modulation capabilities
            of the TG1304.
            (1) AM
                Amplitude Modulation.
            (2) VCA
                Voltage Controlled Attenuation.
            (3) Sum
                Sum the Main and Auxiliary
                generator outputs.
            (4) FM
                Frequency Modulation.
            (5) VCF (Sweep)
                Voltage controlled Frequency.
        (4) Trigger (Burst/Gate)
            Set up and control the Trigger and
            Gate capabilities of the TG1304.
        (5) Set Status
            Configure the IEEE 488.2 status
            reporting capabilities of the TG1304.

 (3) Local Storage
     Executes the Store and Recall commands.

 (4) Get Status
     Returns the current value of the specified
     IEEE 488.2 status byte.

 (5) Miscellaneous
     This class of functions allows access to
     additional TG1304 remote control commands
     which is not available elsewhere in this
     driver. Also included are file operations and
     the user defined reset function which is
     similar to that provided in the Initialise
     function.
        (1) Send Command String
        (2) Get Response String
        (3) File Operations
        (4) Reset

 (6) Close
     Take the instrument offline.    -      Class name:  Configure

  Description: This class of functions configures
               the main and Auxilliary generators
               and allows access to the
               Modulation capabilities of the
               TG1304.

  Functions/class:

        (1) Main Generator
            Set up such TG1304 Main Generator
            parameters as  output function,
            frequency and amplitude.
        (2) Auxiliary Generator
            Set up such TG1304 Auxiliary Generator
            parameters as  output function,
            frequency and amplitude.
        (3) Modulation...
            This class of functions configures and
            controls the Modulation capabilities
            of the TG1304.
            (1) AM
                Amplitude Modulation.
            (2) VCA
                Voltage Controlled Attenuation.
            (3) Sum
                Sum the Main and Auxiliary
                generator outputs.
            (4) FM
                Frequency Modulation.
            (5) VCF (Sweep)
                Voltage controlled Frequency.
        (4) Trigger (Burst/Gate)
            Set up and control the Trigger and
            Gate capabilities of the TG1304.
        (5) Set Status
            Configure the IEEE 488.2 status
            reporting capabilities of the TG1304.
          Class name:  Configure

  Description: This class of functions configures
               and controls the Modulation
               capabilities of the TG1304.

  Functions/class:

            (1) AM
                Amplitude Modulation.
            (2) VCA
                Voltage Controlled Attenuation.
            (3) Sum
                Sum the Main and Auxiliary
                generator outputs.
            (4) FM
                Frequency Modulation.
            (5) VCF (Sweep)
                Voltage controlled Frequency.    a      Class name:   Miscellaneous

  Description:  This class of functions allows
                access to additional TG1304 remote
                control commands which is not
                available elsewhere in this
                driver. Also included are file
                operations and the user defined
                reset function which is similar to
                that provided in the Initialise
                function.

 Functions/classes:
                 (1) Send Command String
                 (2) Get Response String
                 (3) File Operations
                 (4) Reset

    P     Panel Name:    Initialize

 Description:   Initializes the instrument in the
                following ways:

                - opens the instrument and sets
                  its GPIB address to the speci-
                  fied value

                - optionally performs an
                  identification query on the
                  instrument

                - optionally sets the instrument
                  to a default configuration

                - returns an instrument ID which
                  is used to identify the
                  instrument in subsequent calls.    _     Control Name:  Address

 Description:   Specifies the address on the
                GPIB to be used to communicate
                with the instrument.  This value
                must correspond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 to 30

 Default Value: 5    
     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer         Control Name:  ID Query

 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE:  Under normal circumstances the ID Query
        insures that the instrument initialized
        over the GPIB is the type supported by
        this driver. However circumstances may
        arise where it is undesirable to send an
        ID Query to the instrument. In those
        cases; set this control to Skip Query
        and this function will initialize the
        GPIB and the Command arrays in the driver,
        without doing an ID Query.    N     Control Name:  Reset

 Description:   Specifies if the instrument is to
                be reset and if so how the Trigger
                (Burst/Gate) should be set during
                the initialization procedure.

 Variable Type: Integer

 Valid Range:   0 = No Reset
                1 = Trigger Clear
                2 = Burst Int
                3 = Burst Ext
                4 = Gate Int
                5 = Gate Ext

 Default Value: 1 - Trigger Clear

 NOTE: If you do not want the instrument reset.
       Set this control to No Reset while
       initializing the instrument.    u     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      223   Instrument identification query failed
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      240   Instrument timed out     - g           Address                            -          Instrument ID                       `          ID Query                           Y          Reset Device                      L          Error                           "                                          2 9                                            5    	           Do Query 1 Skip Query 0              FNo Reset 0 Trig Clear 1 Burst Int 2 Burst Ext 3 Gate Int 4 Gate Ext 5    	            (Instrument driver version 2.0 Apr. 1995    Copyright (c) TTi Ltd.   X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    #             Instrument ID                      1   &     Panel Name:    Main Generator

 Description:   Sets up Function, Frequency,
                Peak-Peak Output level and Output
                status for the Main Generator.
                Secondary functions are provided
                to set DC Offset, Symmetry and
                Phase.         Control Name:  Function

 Description:   Specifies the output waveform
                function.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = Positive Pulse
                4 = Negative Pulse
                5 = Positive Peak
                6 = Negative Peak
                7 = DC

 Default Value: 0 - Sine          Control Name:  Frequency

 Description:   The output Frequency expressed in
                Hz.

 Variable Type: double

 Valid Range:   1e-2 to 13e+6 (10mHz to 13MHz)

 Default Value: none    @     Control Name:  Pk-Pk Output

 Description:   Specifies the output level as a
                peak to peak EMF value expressed
                in Volts.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                the TG1304 specification for
                details.

 Default Value: none          Control Name:  Output

 Description:   Turns the Main output on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 1 - On          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Function value out of range
       -3   Output value out of range
       -4   Frequency value out of range
       -5   DC offset value out of range
       -6   Symmetry value out of range
       -7   Phase value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    &  K           Function                          (g  t         Frequency (Hz)                    )/           Pk-Pk Output (V)                  *w U          Output                            +*          Error                                         NSine 0 Triangle 1 Square 2 Pos Pulse 3 Neg Pulse 4 Pos Peak 5 Neg Peak 6 DC 7           On 1 Off 0    	                 Control Name:  DC Offset

 Description:   Sets the output Offset voltage as
                an EMF value is expressed in Volts

 Variable Type: double

 Valid Range:   -10 to +10

 Default Value: 0.0    .            DC Offset (V)                      0.0         Control Name:  Symmetry

 Description:   Sets the output Symmetry as a
                percentage.

 Variable Type: double

 Valid Range:   5% to 95%

 Default Value: 50.0%    /            Symmetry (%)                       50.0         Control Name:  Phase

 Description:   Sets the Start/Stop Phase
                parameter expressed in degrees.

 Variable Type: integer

 Valid Range:   -360 to +360

 Default Value: 0    0             Phase (deg)                        0   X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    1             Instrument ID                      1        Panel Name:    Auxiliary Generator

 Description:   Sets up Function, Frequency,
                Peak-Peak Output level and Output
                status for the Auxiliary
                Generator. A secondary functiom
                is provided to set Symmetry.    1     Control Name:  Function

 Description:   Specifies the output waveform
                function.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = Ramp
                4 = FCV
                5 = ACV

 Default Value: 0 - Sine          Control Name:  Frequency

 Description:   The output Frequency expressed in
                Hz.

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50KHz)

 Default Value: none    @     Control Name:  Pk-Pk Output

 Description:   Specifies the output level as a
                peak to peak EMF value expressed
                in Volts.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                the TG1304 specification for
                details.

 Default Value: none          Control Name:  Output

 Description:   Turns the Aux. output on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 1 - On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Function value out of range
       -3   Output value out of range
       -4   Frequency value out of range
       -5   Symmetry value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    5  ?           Function                          6  h         Frequency (Hz)                    7           Pk-Pk Output (V)                  8 I          Output                            9          Error                                         .Sine 0 Triangle 1 Square 2 Ramp 3 FCV 4 ACV 5           On 1 Off 0    	                 Control Name:  Symmetry

 Description:   Sets the output Symmetry as a
                percentage.

 Variable Type: integer

 Valid Range:   5% to 95%

 Default Value: 50    <             Symmetry (%)                       50    v     Panel Name:    AM

 Description:   Enables AM and sets up Waveform,
                Modulation Depth and Frequency.          Control Name:  Enable

 Description:   Sets the status of AM.

 Variable Type: Integer

 Valid Range:   0 = On  - configured and active
                1 = Off - configured and inactive
                2 = Clear - Unconfigured

 Default Value: 0 - On          Control Name:  Waveform

 Description:   Selects the modulation waveform.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = External

 Default Value: 0 - Sine    B     Control Name:  Mod Depth

 Description:   Sets the Depth of modulation
                expressed as a percentage of the
                carrier. This parameter has no
                effect if the modulation Waveform
                is External.

 Variable Type: integer

 Valid Range:   1% to 99%

 Default Value: none         Control Name:  Mod Frequency

 Description:   Sets the internal modulation
                frequency in Hz.This parameter has
                no effect if the modulation
                Waveform is External.
                Note. This parameter is actually
                the Auxiliary generator frequency.

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: none    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Waveform value out of range
       -4   Mod depth value out of range
       -5   Frequency value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    >2 M 5          Enable                            ?7 M           Waveform                          @- M           Mod Depth (%)                     Aw M         Mod Frequency (Hz)                C             Instrument ID                     Er          Error                                         On 0 Off 1 Clear 2               &Sine 0 Triangle 1 Square 2 External 3            1    	                Panel Name:    VCA

 Description:   Enables Voltage Controlled
                Attenuator and sets up the Mode,
                Max and Min Amplitudes and the
                sweep time.

 Note: It is not possible to control the VCA shape
       or the Trigger source with this dirver.
       When Internal VCA is selected They will
       default to Triangle and Free respectively.    O     Control Name:  Max Amplitude

 Description:   Sets the maximum amplitude of the
                carrier at the upper peak of the
                VCA control waveform.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                the TG1304 specification for
                details.

 Default Value: none          Control Name:  Enable

 Description:   Sets the status of VCA.

 Variable Type: Integer

 Valid Range:   0 = On  - configured and active
                1 = Off - configured and inactive
                2 = Clear - Unconfigured

 Default Value: 0 - On         Control Name:  Mode

 Description:   Sets the VCA mode.

 Variable Type: Integer

 Valid Range:   0 = Internal linear
                1 = Internal log
                2 = External linear
                3 = External log

 Default Value: 0 - Internal linear    O     Control Name:  Min Amplitude

 Description:   Sets the minimum amplitude of the
                carrier at the lower peak of the
                VCA control waveform.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                the TG1304 specification for
                details.

 Default Value: none    O     Control Name:  Time

 Description:   Specifies the internal VCA
                triangle waveform period expressed
                in seconds.
                Note. This parameter is actually
                the Auxiliary generator period.

 Variable Type: double

 Valid Range:   20e-6 to 1e+3 (20us to 1000s)

 Default Value: none    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Mode value out of range
       -4   Time value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    J -          Max Amplitude (V)                 K M 5          Enable                            L M           Mode                              M m          Min Amplitude (V)                 OC M         Time (sec)                        P             Instrument ID                     R          Error                                             On 0 Off 1 Clear 2               0Int. Lin. 0 Int. Log. 1 Ext. Lin. 2 Ext. Log. 3            1    	            z     Panel Name:    Sum

 Description:   Enables Sum mode and sets up Sum
                Waveform, Amplitude and Frequency.    1     Control Name:  Enable

 Description:   Sets the status of Summing of the
                Main and Aux generators.

 Variable Type: Integer

 Valid Range:   0 = On  - configured and active
                1 = Off - configured and inactive
                2 = Clear - Unconfigured

 Default Value: 0 - On          Control Name:  Waveform

 Description:   Selects the waveform to be summed.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = External

 Default Value: 0 - Sine         Control Name:  Sum Amplitude

 Description:   Sets the amplitude of the summing
                waveform.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                the TG1304 specification for
                details.

 Default Value: none         Control Name:  Sum Frequency

 Description:   Sets the Frequency of the summing
                waveform in Hz.This parameter has
                no effect if the modulation
                Waveform is External.
                Note. This parameter is actually
                the Auxiliary generator frequency.

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: none    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Waveform value out of range
       -4   Frequency value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    W M 5          Enable                            XO M           Waveform                          YG M          Sum Amplitude (V)                 Za M         Sum Frequency (Hz)                \              Instrument ID                     ^`          Error                                         On 0 Off 1 Clear 2               &Sine 0 Triangle 1 Square 2 External 3            1    	            o     Panel Name:    FM

 Description:   Enables FM and sets up Waveform,
                Deviation and Frequency.          Control Name:  Enable

 Description:   Sets the status of FM.

 Variable Type: Integer

 Valid Range:   0 = On  - configured and active
                1 = Off - configured and inactive
                2 = Clear - Unconfigured

 Default Value: 0 - On          Control Name:  Waveform

 Description:   Selects the modulation waveform.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = External

 Default Value: 0 - Sine    5     Control Name:  Deviation

 Description:   Sets the frequency deviation
                of the carrier in Hz. This
                parameter has no effect if the
                modulation Waveform is External.

 Variable Type: double

 Valid Range:   Carrier wave frequency dependant.

 Default Value: none         Control Name:  Mod Frequency

 Description:   Sets the internal modulation
                frequency in Hz.This parameter has
                no effect if the modulation
                Waveform is External.
                Note. This parameter is actually
                the Auxiliary generator frequency.

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: none    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Waveform value out of range
       -4   Frequency value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out
    b7 M 5          Enable                            c< M           Waveform                          d2 M          Deviation (Hz)                    eo M         Mod Frequency (Hz)                g
             Instrument ID                     ij          Error                                         On 0 Off 1 Clear 2               &Sine 0 Triangle 1 Square 2 External 3            1    	                Panel Name:    Sweep (VCF)

 Description:   Enables Sweep (Voltage Controlled
                Frequency) and sets up the Mode,
                Start and Stop Frequencies and the
                sweep time.

 Note: It is not possible to control the VCF shape
       or the Trigger source with this dirver.
       When Internal VCF is selected They will
       default to Triangle and Free respectively.          Control Name:  Start Frequency

 Description:   The Sweep Start Frequency
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-2 to 13e+6 (10mHz to 13MHz)
                Max sweep range 1000:1.

 Default Value: none          Control Name:  Enable

 Description:   Sets the status of Sweep.

 Variable Type: Integer

 Valid Range:   0 = On  - configured and active
                1 = Off - configured and inactive
                2 = Clear - Unconfigured

 Default Value: 0 - On         Control Name:  Mode

 Description:   Sets the Sweep mode.

 Variable Type: Integer

 Valid Range:   0 = Internal linear
                1 = Internal log
                2 = External linear
                3 = External log

 Default Value: 0 - Internal linear          Control Name:  Stop Frequency

 Description:   The Sweep Stop Frequency
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-2 to 13e+6 (10mHz to 13MHz)
                Max sweep range 1000:1.

 Default Value: none    Q     Control Name:  Time

 Description:   Specifies the internal Sweep
                triangle waveform period expressed
                in seconds.
                Note. This parameter is actually
                the Auxiliary generator period.

 Variable Type: double

 Valid Range:   20e-6 to 1e+3 (20us to 1000s)

 Default Value: none    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Mode value out of range
       -4   Time value out of range
       -5   Start frequency value out of range
       -6   Stop frequency value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    ng -          Start frequency (Hz)              ob M 5          Enable                            pj M           Mode                              qw m          Stop frequency (Hz)               rp M         Time (sec)                        s             Instrument ID                     v)          Error                                             On 0 Off 1 Clear 2               0Int. Lin. 0 Int. Log. 1 Ext. Lin. 2 Ext. Log. 3            1    	           T     Panel Name:    Trigger (Burst/Gate)

 Description:   This panel allows the selected
                mode (Burst/Gate), see note below,
                to be Enabled and the Burst Count,
                Internal Trigger Frequency,
                External Trigger Threshold and
                Gate On and Off Times to be set.

 Note: It is not possible to directly select the
       Trigger (Burst and Gate) functions with
       this dirver. All the numeric parameters may
       be set on this panel but the choice of
       Burst/Gate and Int/Ext must be made using
       the Reset function. See the Initialise and
       Reset panels for more information.
       The common parameters must be specified for
       any mode. The Trigger and Gate parameters
       need only be specified when the relevent
       mode has been activated by reset.         Control Name:  Enable - Common Parameter

 Description:   Sets the status of the Trigger.

 Variable Type: Integer

 Valid Range:   0 = On  - configured and active
                1 = Off - configured and inactive

 Default Value: 0 - On

 Note:  This control will enable and disable the
        trigger mode that was selected the last
        time the Reset function was called. If no
        explicit call has been made then the mode
        set in the Initialise function is used.
        You must specify trigger modes in this
        way as there are no direct commands to
        allow the trigger mode to be set
        otherwise.    0     Control Name:  Burst Count - Trigger Parameter

 Description:   Sets the number of cycles of the
                main generator waveform in each
                burst. Has no effect if Gate mode
                is selected,

 Variable Type: double

 Valid Range:   0.5 to 524288.5

 Default Value: 1.0          Control Name:  Gate On Time - Gate Parameter

 Description:   The On Time of the internal
                Gate signal expressed in sec.

 Variable Type: double

 Valid Range:   800e-9 to 850

 Default Value: 0.05
          Control Name:  Ext Trig Thrshld
                      - Common Parameter
 Description:   The external trigger threshold
                expressed in Volts.

 Variable Type: double

 Valid Range:   -10.0 to +10.0

 Default Value: 0.5
          Control Name:  Int Trigger Period
                         - Trigger Parameter
 Description:   The Period of the internal
                Trigger generator expressed in sec

 Variable Type: double

 Valid Range:   150e-9 to 850

 Default Value: 0.1          Control Name:  Gate Off Time - Gate Parameter

 Description:   The Off Time of the internal
                Gate signal expressed in sec.

 Variable Type: double

 Valid Range:   800e-9 to 850

 Default Value: 0.05    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    8     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Gate on value out of range
       -4   Gate off value out of range
       -5   Trigger threshold value out of range
       -6   Trigger period value out of range
       -7   Burst count value out of range

      -10   Instrument not reset by this driver
      -11   instrument reset to Trigger Off

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out

 Note: It is not possible to directly select the
       Trigger (Burst and Gate) functions with
       this dirver. All the numeric parameters may
       be set on this panel but the choice of
       Burst/Gate and Int/Ext must be made using
       the Reset function. See the Initialise and
       Reset panels for more information. Errors
       -10 and -11 indicate that no Trigger or
       Gate mode has been selected.    }| M Z          Enable                             M          Burst Count                       < Mx         Gate On Time (sec)                  /         Ext Trig Thrshld (V)                         Int Trig Period (s)                x         Gate Off Time (sec)                            Instrument ID                     T          Error                             !                                                                                     q                                                       On 0 Off 1    1    0.05    0.5    0.1    0.05    1    	            Common Parameters    Trig/Burst Parameters    Gate Parameters       Panel name:     Status Reporting

Description:    Specify the way in which status is
                reported and Service Request is
                generated as defined in the IEEE
                488.2 standard.

                The function provides access to
                the three status enable registers
                in the TG1304, these are:

                Service Request Enable Register
                - Specifies which bits, when set,
                  in the Status Byte register will
                  generate a Service Request.

                Standard Event Enable Register
                - Specifies which bits, when set,
                  in the Standard Event Status
                  register will set the ESB bit in
                  the Status Byte Register.


                Parallel Poll Enable Register
                - Specifies which bits, when set,
                  in the Status Byte register will
                  be used to form the ist local
                  message

                See the IEEE 488.2 Standard and
                the instrument  instruction book
                for a full description of status
                reporting capabilities.    <    Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    0 = SRQ enable
                1 = Standard Event Enable
                2 = Parallel Poll

Default value   0 - SRQ Enable
         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    $ ]           Set Status Enable                 h ]          Value                             3             Instrument ID                               Error                                         +SRQ enable 0 Event Enable 1 Parallel Pol 2    0    1    	                Panel name:     Local Storage

Description:    Stores or Recalls the complete
                state of the TG1304 to or from
                local non-volatile memory.          Control Name:  Operation

 Description:   Selects the recall or store
                operation.

 Variable Type: Integer

 Valid Range:   0 = Recall
                1 = Store

 Default Value: 0 - Recall    R    Control name:   Store Number

Description:    Select the number of the store to
                Recall from or Store to.

Variable type:  integer

Valid range:    1 to 64

Default value:  1

 NOTE:  Store 64 is used by the Reset function. it
        is therefore advisable not to use it here
        except in exceptional circumstances.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range
       -3   Store Number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     ]           Operation                          ]          Store Number                      (             Instrument ID                               Error                                         Recall 0 Store 1    1    1    	            x    Panel name:     Read Status

Description:    Returns the byte value from the
                selected status register.    d    Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    0 = Status Byte
                1 = Standard Event Status
                2 = SRQ enable
                3 = Standard Event Enable
                4 = Parallel Poll Enable

Default value   0 - Status Byte

         Control name:   Value

Description:    Returns the value read from the
                selected register.

Variable type:  integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out     ]           Read Status                        ]          Value                                          Instrument ID                               Error                                         EStatus byte 0 Std Event 1 SRQ enable 2 Event Enable 3 Parallel Pol 4    	            1    	                Panel name:     Send command string

Description:    Sends a string of bytes to the
                TG1304 from a string variable.         Control name:   Command String

Description:    This control specifies data to be
                sent to the TG1304. The absolute
                maximum length allowed is 200
                bytes.

Variable type:  String    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    3     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     ]          Command                                        Instrument ID                               Error                                  1    	                Panel name:     Get response string

Description:    Reads a response from the TG1304
                into a string variable.        Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the TG1304. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the TG1304 and
                placed in the string.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    5     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    q ]          Response                           ]          Number Of Bytes                   G             Instrument ID                               Error                              	            	            1    	               Panel name:     File Operations

Description:    Send or Receive a binary block to
                or from the TG1304. The data will
                be read from or written to a file.

Note            This operation is usefull for
                Store blocks.         Control Name:  Operation

 Description:   Selects to send a file to the
                TG1304 or Get a file from TG1304.

 Variable Type: Integer

 Valid Range:   0 = Send file to TG1304
                1 = Get file from TG1304

 Default Value: 0 - Send file         Control name:   File name

Description:    This control specifies file name
                from which the binary block will
                be sent to the TG1304.

Variable type:  String - max length 50 characters    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      232   Instrument not initialized
      240   Instrument timed out     ]           Operation                          ]         File Name                                      Instrument ID                     =          Error                                         Send File 0 Get File 1        1    	                 Panel Name:    Reset

 Description:   This panel is provided to avoid
                the need to Close and then
                re-Initialise the instrument when
                a reset is required    y     Control Name:  Reset

 Description:   Specifies how the instrument is to
                be reset and how the Trigger
                (Burst/Gate) should be set.

 Variable Type: Integer

 Valid Range:   1 = Trigger Clear
                2 = Burst Int
                3 = Burst Ext
                4 = Gate Int
                5 = Gate Ext

 Default Value: 1 - Trigger Clear    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    T     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Reset Device out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     M          Reset Device                      >             Instrument ID                     Ğ          Error                                         ;Trig Clear 1 Burst Int 2 Burst Ext 3 Gate Int 4 Gate Ext 5    1    	                 Panel Name:    Close

 Description:   Closes the instrument and takes it
                off line.

 Note: The  instrument must  be reinitialized
       to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close instrument
      232   Instrument not initialized    Ǩ             Instrument ID                               Error                              1    	                  I        K.    init                                     %n 
  F                                       %  -R          config_main                       /    8    main_offset                       0   d 8    main_symmetry                     1    :    main_phase                               4:    8                                       4t  ;\      w    config_aux                        =y   M 8    aux_symmetry                             =  GM     K.    config_am                                H  T     K.    config_vca                               V  `     K.    config_sum                               a  k     K.    config_fm                                l  x/     K.    config_sweep                             z        K.    trig                                     j  #     K.    set_status                               G       K.    loc_stores                                      K.    get_status                               &  6     K.    snd_cmd                                         K.    get_resp                                        K.    file_ops                                        K.    reset                                      !     K.    close                                                                       DInitialize                          	Configure                           $Main Generator                       Auxiliary Generator                 Modulation                           DAM                                   DVCA                                  DSum                                  DFM                                   DSweep (VCF)                          DTrigger (Burst/Gate)                 DSet Status                           DLocal Storage                        DGet Status                          Miscellaneous                        DSend command string                  DGet Response string                  DFile operations                      DReset                                DClose                           